
unit Androidapi.JNI.Misc;

interface

uses
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes;

type
// ===== Forward declarations =====

  JObjectInputStream = interface;//java.io.ObjectInputStream
  JObjectInputStream_GetField = interface;//java.io.ObjectInputStream$GetField
  JObjectInputValidation = interface;//java.io.ObjectInputValidation
  JObjectOutput = interface;//java.io.ObjectOutput
  JObjectOutputStream = interface;//java.io.ObjectOutputStream
  JObjectOutputStream_PutField = interface;//java.io.ObjectOutputStream$PutField
  Jio_ObjectStreamClass = interface;//java.io.ObjectStreamClass
  JObjectStreamField = interface;//java.io.ObjectStreamField
  //JStringBuffer = interface;//java.lang.StringBuffer
  //JStringBuilder = interface;//java.lang.StringBuilder

// ===== Interface declarations =====

  JObjectInputStreamClass = interface(JInputStreamClass)
    ['{443A1BEF-E21F-4012-A28B-4D7735136BD3}']
    {class} function init(input: JInputStream): JObjectInputStream; cdecl;//Deprecated
    {class} function available: Integer; cdecl;//Deprecated
    {class} function read(buffer: TJavaArray<Byte>; byteOffset: Integer; byteCount: Integer): Integer; cdecl; overload;//Deprecated
    {class} function readBoolean: Boolean; cdecl;//Deprecated
    {class} function readByte: Byte; cdecl;//Deprecated
    {class} function readFloat: Single; cdecl;//Deprecated
    {class} procedure readFully(dst: TJavaArray<Byte>); cdecl; overload;//Deprecated
    {class} procedure readFully(dst: TJavaArray<Byte>; offset: Integer; byteCount: Integer); cdecl; overload;//Deprecated
    {class} function readObject: JObject; cdecl;//Deprecated
    {class} function readShort: SmallInt; cdecl;//Deprecated
    {class} function readUnsignedShort: Integer; cdecl;
    {class} procedure registerValidation(&object: JObjectInputValidation; priority: Integer); cdecl;
    {class} function skipBytes(length: Integer): Integer; cdecl;
  end;

  [JavaSignature('java/io/ObjectInputStream')]
  JObjectInputStream = interface(JInputStream)
    ['{C1360ABB-AF58-4607-B43E-C1E1652E8FC2}']
    procedure close; cdecl;//Deprecated
    procedure defaultReadObject; cdecl;//Deprecated
    function read: Integer; cdecl; overload;//Deprecated
    function readChar: Char; cdecl;//Deprecated
    function readDouble: Double; cdecl;//Deprecated
    function readFields: JObjectInputStream_GetField; cdecl;//Deprecated
    function readInt: Integer; cdecl;//Deprecated
    function readLine: JString; cdecl;//Deprecated
    function readLong: Int64; cdecl;//Deprecated
    function readUTF: JString; cdecl;
    function readUnshared: JObject; cdecl;
    function readUnsignedByte: Integer; cdecl;
    function readObject: JObject; cdecl;
  end;
  TJObjectInputStream = class(TJavaGenericImport<JObjectInputStreamClass, JObjectInputStream>) end;

  JObjectInputStream_GetFieldClass = interface(JObjectClass)
    ['{B2A17356-DC2C-4DD0-BA5B-926AB526F0F6}']
    {class} function init: JObjectInputStream_GetField; cdecl;//Deprecated
    {class} function get(name: JString; defaultValue: Byte): Byte; cdecl; overload;
    {class} function get(name: JString; defaultValue: SmallInt): SmallInt; cdecl; overload;
    {class} function get(name: JString; defaultValue: Integer): Integer; cdecl; overload;
    {class} function get(name: JString; defaultValue: JObject): JObject; cdecl; overload;
    {class} function getObjectStreamClass: Jio_ObjectStreamClass; cdecl;
  end;

  [JavaSignature('java/io/ObjectInputStream$GetField')]
  JObjectInputStream_GetField = interface(JObject)
    ['{B087619B-FB6D-415B-BE57-9D4EBDC7E9B9}']
    function defaulted(name: JString): Boolean; cdecl;
    function get(name: JString; defaultValue: Boolean): Boolean; cdecl; overload;
    function get(name: JString; defaultValue: Char): Char; cdecl; overload;
    function get(name: JString; defaultValue: Int64): Int64; cdecl; overload;
    function get(name: JString; defaultValue: Single): Single; cdecl; overload;
    function get(name: JString; defaultValue: Double): Double; cdecl; overload;
  end;
  TJObjectInputStream_GetField = class(TJavaGenericImport<JObjectInputStream_GetFieldClass, JObjectInputStream_GetField>) end;

  JObjectInputValidationClass = interface(IJavaClass)
    ['{62ED8408-3F77-4D14-869F-9B23C6114A7E}']
    {class} procedure validateObject; cdecl;
  end;

  [JavaSignature('java/io/ObjectInputValidation')]
  JObjectInputValidation = interface(IJavaInstance)
    ['{84E8CFA7-F64F-43D1-AC79-DAE8ADB43A56}']
  end;
  TJObjectInputValidation = class(TJavaGenericImport<JObjectInputValidationClass, JObjectInputValidation>) end;

  JObjectOutputClass = interface(JAutoCloseableClass)
    ['{F4A98D44-0FB7-4173-B4CF-B078F3B70FD9}']
    {class} procedure flush; cdecl;
    {class} procedure write(buffer: TJavaArray<Byte>); cdecl; overload;
    {class} procedure write(buffer: TJavaArray<Byte>; offset: Integer; count: Integer); cdecl; overload;
  end;

  [JavaSignature('java/io/ObjectOutput')]
  JObjectOutput = interface(JAutoCloseable)
    ['{6161B3E5-4157-483D-A2E5-BBD585E248FB}']
    procedure close; cdecl;
    procedure write(value: Integer); cdecl; overload;
    procedure writeObject(obj: JObject); cdecl;
  end;
  TJObjectOutput = class(TJavaGenericImport<JObjectOutputClass, JObjectOutput>) end;

  JObjectOutputStreamClass = interface(JOutputStreamClass)
    ['{D43CF30C-1E94-4D2E-A473-91EE54E41F07}']
    {class} function init(output: JOutputStream): JObjectOutputStream; cdecl;//Deprecated
  end;

  [JavaSignature('java/io/ObjectOutputStream')]
  JObjectOutputStream = interface(JOutputStream)
    ['{F4E441F8-B3D0-4463-A052-880F6644FB42}']
    procedure close; cdecl;//Deprecated
    procedure defaultWriteObject; cdecl;//Deprecated
    procedure flush; cdecl;//Deprecated
    function putFields: JObjectOutputStream_PutField; cdecl;//Deprecated
    procedure reset; cdecl;//Deprecated
    procedure useProtocolVersion(version: Integer); cdecl;//Deprecated
    procedure writeByte(value: Integer); cdecl;//Deprecated
    procedure writeBytes(value: JString); cdecl;//Deprecated
    procedure writeChar(value: Integer); cdecl;//Deprecated
    procedure writeFloat(value: Single); cdecl;
    procedure writeInt(value: Integer); cdecl;
    procedure writeLong(value: Int64); cdecl;
    procedure writeUnshared(&object: JObject); cdecl;
    procedure write(buffer: TJavaArray<Byte>; offset: Integer; length: Integer); cdecl; overload;//Deprecated
    procedure write(value: Integer); cdecl; overload;//Deprecated
    procedure writeBoolean(value: Boolean); cdecl;//Deprecated
    procedure writeChars(value: JString); cdecl;
    procedure writeDouble(value: Double); cdecl;
    procedure writeFields; cdecl;
    procedure writeObject(&object: JObject); cdecl;
    procedure writeShort(value: Integer); cdecl;
    procedure writeUTF(value: JString); cdecl;
  end;
  TJObjectOutputStream = class(TJavaGenericImport<JObjectOutputStreamClass, JObjectOutputStream>) end;

  JObjectOutputStream_PutFieldClass = interface(JObjectClass)
    ['{C280794E-D22D-40E4-854E-442CAC3B5350}']
    {class} function init: JObjectOutputStream_PutField; cdecl;//Deprecated
    {class} procedure put(name: JString; value: Char); cdecl; overload;
    {class} procedure put(name: JString; value: Byte); cdecl; overload;
    {class} procedure put(name: JString; value: SmallInt); cdecl; overload;
    {class} procedure put(name: JString; value: Double); cdecl; overload;
    {class} procedure put(name: JString; value: JObject); cdecl; overload;
    {class} procedure write(out: JObjectOutput); cdecl;//Deprecated
  end;

  [JavaSignature('java/io/ObjectOutputStream$PutField')]
  JObjectOutputStream_PutField = interface(JObject)
    ['{0312E88F-1456-44D3-820F-C162F2F9CCAF}']
    procedure put(name: JString; value: Boolean); cdecl; overload;
    procedure put(name: JString; value: Integer); cdecl; overload;
    procedure put(name: JString; value: Int64); cdecl; overload;
    procedure put(name: JString; value: Single); cdecl; overload;
  end;
  TJObjectOutputStream_PutField = class(TJavaGenericImport<JObjectOutputStream_PutFieldClass, JObjectOutputStream_PutField>) end;

  Jio_ObjectStreamClassClass = interface(JObjectClass)
    ['{58DBAE53-DDE4-43B3-8112-035D4955F07D}']
    {class} function _GetNO_FIELDS: TJavaObjectArray<JObjectStreamField>; cdecl;
    {class} function forClass: Jlang_Class; cdecl;//Deprecated
    {class} function getField(name: JString): JObjectStreamField; cdecl;//Deprecated
    {class} function lookup(cl: Jlang_Class): Jio_ObjectStreamClass; cdecl;//Deprecated
    {class} function lookupAny(cl: Jlang_Class): Jio_ObjectStreamClass; cdecl;//Deprecated
    {class} function toString: JString; cdecl;//Deprecated
    {class} property NO_FIELDS: TJavaObjectArray<JObjectStreamField> read _GetNO_FIELDS;
  end;

  [JavaSignature('java/io/ObjectStreamClass')]
  Jio_ObjectStreamClass = interface(JObject)
    ['{13F49D75-C16F-47C6-91F9-B37C879D7FF2}']
    function getFields: TJavaObjectArray<JObjectStreamField>; cdecl;//Deprecated
    function getName: JString; cdecl;//Deprecated
    function getSerialVersionUID: Int64; cdecl;//Deprecated
  end;
  TJio_ObjectStreamClass = class(TJavaGenericImport<Jio_ObjectStreamClassClass, Jio_ObjectStreamClass>) end;

  JObjectStreamFieldClass = interface(JObjectClass)
    ['{FE2D8AF0-961B-40C3-834D-38B8B5258EDA}']
    {class} function init(name: JString; cl: Jlang_Class): JObjectStreamField; cdecl; overload;//Deprecated
    {class} function init(name: JString; cl: Jlang_Class; unshared: Boolean): JObjectStreamField; cdecl; overload;//Deprecated
    {class} function getName: JString; cdecl;//Deprecated
    {class} function getOffset: Integer; cdecl;//Deprecated
    {class} function getType: Jlang_Class; cdecl;//Deprecated
    {class} function isUnshared: Boolean; cdecl;//Deprecated
    {class} function toString: JString; cdecl;//Deprecated
  end;

  [JavaSignature('java/io/ObjectStreamField')]
  JObjectStreamField = interface(JObject)
    ['{A48306B9-9899-47BD-BE6B-4C5922811119}']
    function compareTo(o: JObject): Integer; cdecl;//Deprecated
    function getTypeCode: Char; cdecl;//Deprecated
    function getTypeString: JString; cdecl;//Deprecated
    function isPrimitive: Boolean; cdecl;//Deprecated
  end;
  TJObjectStreamField = class(TJavaGenericImport<JObjectStreamFieldClass, JObjectStreamField>) end;

  // java.lang.StringBuffer
  // java.lang.StringBuilder
implementation

procedure RegisterTypes;
begin
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectInputStream', TypeInfo(Androidapi.JNI.Misc.JObjectInputStream));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectInputStream_GetField', TypeInfo(Androidapi.JNI.Misc.JObjectInputStream_GetField));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectInputValidation', TypeInfo(Androidapi.JNI.Misc.JObjectInputValidation));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectOutput', TypeInfo(Androidapi.JNI.Misc.JObjectOutput));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectOutputStream', TypeInfo(Androidapi.JNI.Misc.JObjectOutputStream));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectOutputStream_PutField', TypeInfo(Androidapi.JNI.Misc.JObjectOutputStream_PutField));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.Jio_ObjectStreamClass', TypeInfo(Androidapi.JNI.Misc.Jio_ObjectStreamClass));
  TRegTypes.RegisterType('Androidapi.JNI.Misc.JObjectStreamField', TypeInfo(Androidapi.JNI.Misc.JObjectStreamField));
  //TRegTypes.RegisterType('Androidapi.JNI.Misc.JStringBuffer', TypeInfo(Androidapi.JNI.Misc.JStringBuffer));
  //TRegTypes.RegisterType('Androidapi.JNI.Misc.JStringBuilder', TypeInfo(Androidapi.JNI.Misc.JStringBuilder));
end;

initialization
  RegisterTypes;
end.

